const serverSystem = server.registerSystem(0, 0);

// Setup which events to listen for
serverSystem.initialize = function () {
  // listen for the placing event and dump output
  this.listenForEvent('minecraft:player_placed_block', (eventData) => {
    let player = eventData.data.player

    let component = this.getComponent(player, 'minecraft:hand_container')
    this.chat(JSON.stringify(component))
  })
}

// per-tick updates
serverSystem.update = function() {
}

serverSystem.chat = function (message) {
	let event = this.createEventData('minecraft:display_chat_event')
	event.data.message = message
	this.broadcastEvent('minecraft:display_chat_event', event)
}
